<?php
/**
 * Created by vm.pl
 * User: Rafał Ignaszewski (rafal@vm.pl)
 * Date: 11.12.13 15:14
 */

namespace VM\AdminBundle\Services;

use Doctrine\ORM\EntityManager;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\Request;

class SsoCommunication
{
    /**
     * Url to SSO
     * @var string
     */
    protected $ssoUrlLogin;

    /**
     * Application Key
     *
     * @var string
     */
    protected $ssoAppKey;


    /**
     * Curl request object
     *
     * @var
     */
    protected $curlRequest;



    public function __construct($SsoUrlLogin, $SsoAppKey)
    {
        $this->ssoUrlLogin = $SsoUrlLogin;
        $this->ssoAppKey = $SsoAppKey;
    }


    public function loginUser($email, $password)
    {
        $this->initConnection();
        $data = array(
            'email' => $email,
            'password' => $password
        );
        return $this->executeAndGetResponse('user_login', $data);
    }


    public function logoutUser($user_id, $token)
    {
        $this->initConnection();
        $data = array(
            'user_id' => $user_id,
            'token' => $token
        );
        return $this->executeAndGetResponse('user_logout', $data);
    }

    public function registerUser($name, $surname, $email, $password = 0)
    {
        if($password === 0)
            $password = md5(sha1(rand(1, 1000000)));
        $this->initConnection();
        $data = array(
            'name' => $name,
            'surname' => $surname,
            'email' => $email,
            'password' => $password
        );
        return $this->executeAndGetResponse('user_register', $data);
    }

    public function registrationConfirm($userId, $confirmationToken)
    {
        $this->initConnection();
        $data = array(
            'user_id' => $userId,
            'confirmation_token' => $confirmationToken
        );
        return $this->executeAndGetResponse('user_registration_confirm', $data);
    }


    public function userGeneratePasswordRecoveryToken($email)
    {
        $this->initConnection();
        $data = array(
            'email' => $email
        );
        return $this->executeAndGetResponse('user_generate_password_recovery_token', $data);
    }

    public function userChangePassword($email, $passwordRecoveryToken, $password)
    {
        $this->initConnection();
        $data = array(
            'email' => $email,
            'password_recovery_token' => $passwordRecoveryToken,
            'password' => $password
        );
        return $this->executeAndGetResponse('user_change_password', $data);
    }

    public function updateUser($userId, $userData)
    {
        $this->initConnection();
        $data = array(
            'user_id' => $userId,
            'data' => $userData
        );
        return $this->executeAndGetResponse('user_app_update', $data);
    }


    public function deleteUser($userId)
    {
        $this->initConnection();
        $data = array(
            'user_id' => $userId
        );
        return $this->executeAndGetResponse('user_app_delete', $data);
    }


    public function checkUserToken($userId, $token)
    {
        $this->initConnection();
        $data = array(
            'user_id' => $userId,
            'token' => $token
        );
        return $this->executeAndGetResponse('user_check_token', $data);
    }


    public function userSetRoles($userId, $token, $roles)
    {
        $this->initConnection();
        $data = array(
            'user_id' => $userId,
            'token' => $token,
            'application' => 'GAME',
            'roles' => $roles
        );
        return $this->executeAndGetResponse('user_set_roles', $data);
    }

    public function userGetRoles($userId, $token)
    {
        $this->initConnection();
        $data = array(
            'user_id' => $userId,
            'token' => $token,
            'application' => 'GAME'
        );
        return $this->executeAndGetResponse('user_get_roles', $data);
    }


    protected function initConnection()
    {
        $this->curlRequest = curl_init($this->ssoUrlLogin);
    }



    protected function executeAndGetResponse($method, $data)
    {
        $params = array(
            'params' => $data,
            'appKey' => $this->ssoAppKey,
            'method' => $method,
        );


        $options = array(
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_HTTPHEADER => array('Content-type: application/json') ,
            CURLOPT_POSTFIELDS => json_encode($params)
        );

        curl_setopt_array($this->curlRequest, $options);

        $response = curl_exec($this->curlRequest);

        $this->primaryValidation($response);

        return json_decode($response, true);
    }


    /**
     * @param $responseString
     * @throws \Exception
     */
    protected function primaryValidation($responseString)
    {
        $info = curl_getinfo($this->curlRequest);
        if($info['http_code'] != 200)
        {
            throw new \Exception('response is empty', 404);
        }

        $error = curl_error($this->curlRequest);
        if(!empty($error))
        {
            throw new \Exception($error, 1010);
        }

        if(empty($responseString))
        {
            throw new \Exception('response is empty', 1000);
        }

        $response = json_decode($responseString, true);
        if(isset($response['error']))
        {
            throw new \Exception('SSO: '.$response['error']['message'], $response['error']['code']);
        }
    }
}